<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
	$email = filter_var(trim($_POST["50off-email"]), FILTER_SANITIZE_EMAIL);
	$spamdetection = $_POST["sdetect"];
	$consent = $_POST["consent"];

	// Check that data was sent to the mailer.
	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		// Set a 400 (bad request) response code and exit.
		http_response_code(400);
		echo "Oops! There was a problem with your submission. Please complete the form and try again.";
		exit;
	}
	
	// Honeypot spam detection
	if ($spamdetection != 'QuadraNet') {
		// Set a 400 (bad request) response code and exit.
		http_response_code(400);
		echo "Oops! There was a problem with your submission. Please complete the form and try again.";
		exit;
	}
	if ($consent != '1') {
		// Set a 400 (bad request) response code and exit.
		http_response_code(400);
		echo "Oops! There was a problem with your submission. Please complete the form and try again.";
		exit;
	}

	// Set the recipient email address.
	$recipient = "sales@quadranet.com";

	// Set the email subject.
	$subject = "Interest in Dedicated Servers";

	// Build the email content.
	$email_content = "Hi! I am interested in the 50% off first-month offer. Please get in touch with me on: $email\n";

	// Build the email headers.
	$email_headers = "From: Customer <$email>";

	// Send the email.
	if (mail($recipient, $subject, $email_content, $email_headers)) {
		// Set a 200 (okay) response code.
		http_response_code(200);
		echo "Thank You! Your message has been sent.";
	} else {
		// Set a 500 (internal server error) response code.
		http_response_code(500);
		echo "Oops! Something went wrong and we couldn't send your message.";
	}

} else {
	// Not a POST request, set a 403 (forbidden) response code.
	http_response_code(403);
	echo "There was a problem with your submission, please try again.";
}

?>